<?php
/*
    Plugin Name: Classic Cart and Checkout For WooCommerce
    Plugin URI: https://sysbasics.com/classic-cart-checkout-for-woocommerce
    Description: Restore your old cart and checkout experience which has been replaced with Gutenberg cart and checkout block experience after 8.3.0.
    Version: 1.0.0
    Author: SysBasics
    Author URI: https://sysbasics.com
    Domain Path: /languages
    Requires at least: 3.3
    Tested up to: 6.4.2
    WC requires at least: 3.0.0
    WC tested up to: 8.3.1
*/

    load_plugin_textdomain( 'classic-cart-and-checkout-for-woocommerce', false, basename( dirname(__FILE__) ).'/languages' );

    add_action( 'before_woocommerce_init', function() {
        if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
            \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
        }
    } );

    add_action( 'init', 'ccacfw_check_for_cart_pages' );

    add_action( 'init', 'ccacfw_check_for_checkout_pages' );

/**
 * Get account menu item classes.
 *
 * @since 1.0.0
 */

if (!function_exists('ccacfw_check_for_cart_pages')) {

    function ccacfw_check_for_cart_pages() {

        $has_old_cart_page         = get_option("ccacfw_old_cart_page_exists",'no');
        $cart_migration_done       = get_option("ccacfw_cart_migration_done",'no');
        $ccacfw_old_cart_page_id   = get_option("ccacfw_old_cart_page_id");



        if (isset($ccacfw_old_cart_page_id) && ($ccacfw_old_cart_page_id != "")) {
            return;
        } else {

         $page_ids = get_all_page_ids();

         $cart_shortcode_found = 'no';

         if (($has_old_cart_page == "no") && ($cart_migration_done != "yes")) {

            foreach($page_ids as $new_id) {



                $content_post = get_post($new_id);
                $content = $content_post->post_content;



                if (has_shortcode( $content, 'woocommerce_cart')) {

                    $cart_shortcode_found = 'yes';

                }

            }

        }
        

        if ($cart_shortcode_found == "yes") {
            update_option("ccacfw_old_cart_page_exists",'yes');

            update_option("ccacfw_cart_migration_done",'yes');

        }

        


        $has_old_cart_page         = get_option("ccacfw_old_cart_page_exists",'no');

        $cart_migration_done       = get_option("ccacfw_cart_migration_done",'no');

        if (($has_old_cart_page == "no") && ($cart_migration_done != "yes")) {
            $my_post = array(
              'post_title'    => __("Cart","classic-cart-and-checkout-for-woocommerce"),
              'post_content'  => '[woocommerce_cart]',
              'post_status'   => 'publish',
              'post_type'     => 'page',
              'post_name' => 'cart-old'           
          );


            $new_cart_id = wp_insert_post( $my_post );

            update_option('ccacfw_old_cart_page_id',$new_cart_id);

            $woocommerce_cart_page_id = get_option('woocommerce_cart_page_id');

            if ($woocommerce_cart_page_id != $new_cart_id) {
                update_option('woocommerce_cart_page_id',$new_cart_id);

                update_option("ccacfw_previous_cart_id",$woocommerce_cart_page_id);
            }

            
        }

    }
}
}


/**
 * Get account menu item classes.
 *
 * @since 1.0.0
 */

if (!function_exists('ccacfw_check_for_checkout_pages')) {

    function ccacfw_check_for_checkout_pages() {

        $has_old_checkout_page         = get_option("ccacfw_old_checkout_page_exists",'no');
        $checkout_migration_done       = get_option("ccacfw_checkout_migration_done",'no');
        $ccacfw_old_checkout_page_id   = get_option("ccacfw_old_checkout_page_id");

        if (isset($ccacfw_old_checkout_page_id) && ($ccacfw_old_checkout_page_id != "")) {
            return;
        } else {

         $page_ids = get_all_page_ids();

         $checkout_shortcode_found = 'no';

         if (($has_old_checkout_page == "no") && ($checkout_migration_done != "yes")) {

            foreach($page_ids as $new_id) {



                $content_post = get_post($new_id);
                $content = $content_post->post_content;



                if (has_shortcode( $content, 'woocommerce_checkout')) {

                    $checkout_shortcode_found = 'yes';

                }

            }

        }
        

        if ($checkout_shortcode_found == "yes") {
            update_option("ccacfw_old_checkout_page_exists",'yes');

            update_option("ccacfw_checkout_migration_done",'yes');

        }

        


        $has_old_checkout_page         = get_option("ccacfw_old_checkout_page_exists",'no');

        $checkout_migration_done       = get_option("ccacfw_checkout_migration_done",'no');

        if (($has_old_checkout_page == "no") && ($checkout_migration_done != "yes")) {
            $my_post = array(
              'post_title'    => __("Checkout","classic-cart-and-checkout-for-woocommerce"),
              'post_content'  => '[woocommerce_checkout]',
              'post_status'   => 'publish',
              'post_type'     => 'page',
              'post_name'     => 'checkout-old'          
          );


            $new_cart_id = wp_insert_post( $my_post );

            update_option('ccacfw_old_checkout_page_id',$new_cart_id);

            $woocommerce_checkout_page_id = get_option('woocommerce_checkout_page_id');

            if ($woocommerce_checkout_page_id != $new_cart_id) {
                update_option('woocommerce_checkout_page_id',$new_cart_id);

                update_option("ccacfw_previous_checkout_id",$woocommerce_checkout_page_id);
            }
        }

    }
}
}

register_deactivation_hook( __FILE__, 'ccacfw_remove_options_on_plugin_deactivation' );


/**
 * Get account menu item classes.
 *
 * @since 1.0.0
 */

if (!function_exists('ccacfw_remove_options_on_plugin_deactivation')) {

    function ccacfw_remove_options_on_plugin_deactivation() {
       $original_cart_id = get_option('ccacfw_previous_cart_id');

       update_option('woocommerce_cart_page_id',$original_cart_id);

       $original_checkout_id = get_option('ccacfw_previous_checkout_id');

       update_option('woocommerce_checkout_page_id',$original_checkout_id);

       $old_cart_id  = get_option('ccacfw_old_cart_page_id');

       wp_delete_post($old_cart_id, true);

       delete_option('ccacfw_old_cart_page_id');
       $old_checkout_id = get_option('ccacfw_old_checkout_page_id');

       delete_option('ccacfw_old_checkout_page_id');

       
       wp_delete_post($old_checkout_id, true);

       delete_option('ccacfw_previous_cart_id');
       delete_option('ccacfw_previous_checkout_id');
   } 
}